<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateExpertsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
{
    Schema::create('experts', function (Blueprint $table) {
        $table->id();
        $table->string('name');
        $table->string('profile_picture')->nullable();
        $table->decimal('win_rate', 5, 2);
        $table->decimal('min_startup_capital', 15, 2);
        $table->decimal('profit_share_percentage', 5, 2);
        $table->decimal('total_profit', 15, 2)->default(0);
        $table->timestamps();
    });
}


    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
{
    Schema::dropIfExists('experts');
}

}
