'use strict';

/**
 * Error which indicates that MetaTrader terminal did not start yet. You need to wait until account is connected and
 * retry.
 */

Object.defineProperty(exports, "__esModule", {
  value: true
});
class NotConnectedError extends Error {

  /**
   * Constructs the error
   * @param {String} message error message
   */
  constructor(message) {
    super(message);
    this.name = 'NotConnectedError';
  }

}
exports.default = NotConnectedError;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uL2xpYi9jbGllbnRzL21ldGFBcGkvbm90Q29ubmVjdGVkRXJyb3IuZXM2Il0sIm5hbWVzIjpbIk5vdENvbm5lY3RlZEVycm9yIiwiRXJyb3IiLCJjb25zdHJ1Y3RvciIsIm1lc3NhZ2UiLCJuYW1lIl0sIm1hcHBpbmdzIjoiQUFBQTs7QUFFQTs7Ozs7Ozs7QUFJZSxNQUFNQSxpQkFBTixTQUFnQ0MsS0FBaEMsQ0FBc0M7O0FBRW5EOzs7O0FBSUFDLGNBQVlDLE9BQVosRUFBcUI7QUFDbkIsVUFBTUEsT0FBTjtBQUNBLFNBQUtDLElBQUwsR0FBWSxtQkFBWjtBQUNEOztBQVRrRDtrQkFBaENKLGlCIiwiZmlsZSI6Im5vdENvbm5lY3RlZEVycm9yLmpzIiwic291cmNlc0NvbnRlbnQiOlsiJ3VzZSBzdHJpY3QnO1xuXG4vKipcbiAqIEVycm9yIHdoaWNoIGluZGljYXRlcyB0aGF0IE1ldGFUcmFkZXIgdGVybWluYWwgZGlkIG5vdCBzdGFydCB5ZXQuIFlvdSBuZWVkIHRvIHdhaXQgdW50aWwgYWNjb3VudCBpcyBjb25uZWN0ZWQgYW5kXG4gKiByZXRyeS5cbiAqL1xuZXhwb3J0IGRlZmF1bHQgY2xhc3MgTm90Q29ubmVjdGVkRXJyb3IgZXh0ZW5kcyBFcnJvciB7XG5cbiAgLyoqXG4gICAqIENvbnN0cnVjdHMgdGhlIGVycm9yXG4gICAqIEBwYXJhbSB7U3RyaW5nfSBtZXNzYWdlIGVycm9yIG1lc3NhZ2VcbiAgICovXG4gIGNvbnN0cnVjdG9yKG1lc3NhZ2UpIHtcbiAgICBzdXBlcihtZXNzYWdlKTtcbiAgICB0aGlzLm5hbWUgPSAnTm90Q29ubmVjdGVkRXJyb3InO1xuICB9XG5cbn1cbiJdfQ==