'use strict';

/**
 * Error which indicates that MetaApi MetaTrader account was not synchronized yet. See
 * https://metaapi.cloud/docs/client/websocket/synchronizationMode/ for more details
 */

Object.defineProperty(exports, "__esModule", {
  value: true
});
class NotSynchronizedError extends Error {

  /**
   * Constructs the error
   * @param {String} message error message
   */
  constructor(message) {
    super(message);
    this.name = 'NotSynchronizedError';
  }

}
exports.default = NotSynchronizedError;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uL2xpYi9jbGllbnRzL21ldGFBcGkvbm90U3luY2hyb25pemVkRXJyb3IuZXM2Il0sIm5hbWVzIjpbIk5vdFN5bmNocm9uaXplZEVycm9yIiwiRXJyb3IiLCJjb25zdHJ1Y3RvciIsIm1lc3NhZ2UiLCJuYW1lIl0sIm1hcHBpbmdzIjoiQUFBQTs7QUFFQTs7Ozs7Ozs7QUFJZSxNQUFNQSxvQkFBTixTQUFtQ0MsS0FBbkMsQ0FBeUM7O0FBRXREOzs7O0FBSUFDLGNBQVlDLE9BQVosRUFBcUI7QUFDbkIsVUFBTUEsT0FBTjtBQUNBLFNBQUtDLElBQUwsR0FBWSxzQkFBWjtBQUNEOztBQVRxRDtrQkFBbkNKLG9CIiwiZmlsZSI6Im5vdFN5bmNocm9uaXplZEVycm9yLmpzIiwic291cmNlc0NvbnRlbnQiOlsiJ3VzZSBzdHJpY3QnO1xuXG4vKipcbiAqIEVycm9yIHdoaWNoIGluZGljYXRlcyB0aGF0IE1ldGFBcGkgTWV0YVRyYWRlciBhY2NvdW50IHdhcyBub3Qgc3luY2hyb25pemVkIHlldC4gU2VlXG4gKiBodHRwczovL21ldGFhcGkuY2xvdWQvZG9jcy9jbGllbnQvd2Vic29ja2V0L3N5bmNocm9uaXphdGlvbk1vZGUvIGZvciBtb3JlIGRldGFpbHNcbiAqL1xuZXhwb3J0IGRlZmF1bHQgY2xhc3MgTm90U3luY2hyb25pemVkRXJyb3IgZXh0ZW5kcyBFcnJvciB7XG5cbiAgLyoqXG4gICAqIENvbnN0cnVjdHMgdGhlIGVycm9yXG4gICAqIEBwYXJhbSB7U3RyaW5nfSBtZXNzYWdlIGVycm9yIG1lc3NhZ2VcbiAgICovXG4gIGNvbnN0cnVjdG9yKG1lc3NhZ2UpIHtcbiAgICBzdXBlcihtZXNzYWdlKTtcbiAgICB0aGlzLm5hbWUgPSAnTm90U3luY2hyb25pemVkRXJyb3InO1xuICB9XG5cbn1cbiJdfQ==