'use strict';

/**
 * Error which indicates that a trade have failed
 */

Object.defineProperty(exports, "__esModule", {
  value: true
});
class TradeError extends Error {

  /**
   * Constructs the error
   * @param {String} message error message
   * @param {Number} numericCode numeric error code
   * @param {String} stringCode string error code
   */
  constructor(message, numericCode, stringCode) {
    super(message);
    this.name = 'TradeError';
    this.numericCode = numericCode;
    this.stringCode = stringCode;
  }

}
exports.default = TradeError;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uL2xpYi9jbGllbnRzL21ldGFBcGkvdHJhZGVFcnJvci5lczYiXSwibmFtZXMiOlsiVHJhZGVFcnJvciIsIkVycm9yIiwiY29uc3RydWN0b3IiLCJtZXNzYWdlIiwibnVtZXJpY0NvZGUiLCJzdHJpbmdDb2RlIiwibmFtZSJdLCJtYXBwaW5ncyI6IkFBQUE7O0FBRUE7Ozs7Ozs7QUFHZSxNQUFNQSxVQUFOLFNBQXlCQyxLQUF6QixDQUErQjs7QUFFNUM7Ozs7OztBQU1BQyxjQUFZQyxPQUFaLEVBQXFCQyxXQUFyQixFQUFrQ0MsVUFBbEMsRUFBOEM7QUFDNUMsVUFBTUYsT0FBTjtBQUNBLFNBQUtHLElBQUwsR0FBWSxZQUFaO0FBQ0EsU0FBS0YsV0FBTCxHQUFtQkEsV0FBbkI7QUFDQSxTQUFLQyxVQUFMLEdBQWtCQSxVQUFsQjtBQUNEOztBQWIyQztrQkFBekJMLFUiLCJmaWxlIjoidHJhZGVFcnJvci5qcyIsInNvdXJjZXNDb250ZW50IjpbIid1c2Ugc3RyaWN0JztcblxuLyoqXG4gKiBFcnJvciB3aGljaCBpbmRpY2F0ZXMgdGhhdCBhIHRyYWRlIGhhdmUgZmFpbGVkXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIFRyYWRlRXJyb3IgZXh0ZW5kcyBFcnJvciB7XG5cbiAgLyoqXG4gICAqIENvbnN0cnVjdHMgdGhlIGVycm9yXG4gICAqIEBwYXJhbSB7U3RyaW5nfSBtZXNzYWdlIGVycm9yIG1lc3NhZ2VcbiAgICogQHBhcmFtIHtOdW1iZXJ9IG51bWVyaWNDb2RlIG51bWVyaWMgZXJyb3IgY29kZVxuICAgKiBAcGFyYW0ge1N0cmluZ30gc3RyaW5nQ29kZSBzdHJpbmcgZXJyb3IgY29kZVxuICAgKi9cbiAgY29uc3RydWN0b3IobWVzc2FnZSwgbnVtZXJpY0NvZGUsIHN0cmluZ0NvZGUpIHtcbiAgICBzdXBlcihtZXNzYWdlKTtcbiAgICB0aGlzLm5hbWUgPSAnVHJhZGVFcnJvcic7XG4gICAgdGhpcy5udW1lcmljQ29kZSA9IG51bWVyaWNDb2RlO1xuICAgIHRoaXMuc3RyaW5nQ29kZSA9IHN0cmluZ0NvZGU7XG4gIH1cblxufVxuIl19