'use strict';

var _promise = require('babel-runtime/core-js/promise');

var _promise2 = _interopRequireDefault(_promise);

var _index = require('../index');

var _index2 = _interopRequireDefault(_index);

var _sinon = require('sinon');

var _sinon2 = _interopRequireDefault(_sinon);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

require('dotenv').config();
const token = process.env.TOKEN;
let login = process.env.LOGIN_MT4;
let password = process.env.PASSWORD_MT4;
let serverName = process.env.SERVER_MT4 || 'Tradeview-Demo';
let brokerSrvFile = process.env.PATH_TO_BROKER_SRV || './lib/integration-tests/files/tradeview-demo.broker.srv';
const api = new _index2.default(token, { application: 'MetaApi', domain: 'project-stock.v3.agiliumlabs.cloud' });

describe('MT4 sync positions test', () => {

  async function checkPositions(streamingConnection, rpcConnection) {
    return { local: streamingConnection.terminalState.positions.length,
      real: (await rpcConnection.getPositions()).length };
  }

  // eslint-disable-next-line max-statements
  it('should show correct positions amount after opening and closing', async function () {
    if (token && login) {
      const profiles = await api.provisioningProfileApi.getProvisioningProfiles();
      this.timeout(600000);
      let profile = profiles.find(p => p.name === serverName);
      if (!profile) {
        profile = await api.provisioningProfileApi.createProvisioningProfile({
          name: serverName,
          version: 4,
          brokerTimezone: 'EET',
          brokerDSTSwitchTimezone: 'EET'
        });
        await profile.uploadFile('broker.srv', brokerSrvFile);
      }
      if (profile && profile.status === 'new') {
        await profile.uploadFile('broker.srv', brokerSrvFile);
      }
      let accounts = await api.metatraderAccountApi.getAccounts();
      let account = accounts.find(a => a.login === login && a.type === 'cloud-g2');
      if (!account) {
        account = await api.metatraderAccountApi.createAccount({
          name: 'Test account-mt4',
          type: 'cloud-g2',
          login: login,
          password: password,
          server: serverName,
          provisioningProfileId: profile.id,
          application: 'MetaApi',
          magic: 1000
        });
      }
      await account.deploy();
      await account.waitConnected();
      const streamingConnection = account.getStreamingConnection();
      const rpcConnection = account.getRPCConnection();
      await streamingConnection.connect();
      await streamingConnection.waitSynchronized({ timeoutInSeconds: 600 });
      await rpcConnection.waitSynchronized();
      const startPositions = streamingConnection.terminalState.positions.length;
      const positionIds = [];
      for (let i = 0; i < 10; i++) {
        let result = await streamingConnection.createMarketBuyOrder('GBPUSD', 0.01, 0.9, 2.0);
        positionIds.push(result.positionId);
        await new _promise2.default(res => setTimeout(res, 200));
      }
      await new _promise2.default(res => setTimeout(res, 200));
      let positions = await checkPositions(streamingConnection, rpcConnection);
      _sinon2.default.assert.match(positions.local, startPositions + 10);
      _sinon2.default.assert.match(positions.real, startPositions + 10);
      await new _promise2.default(res => setTimeout(res, 5000));
      await _promise2.default.all(positionIds.map(async id => {
        await streamingConnection.closePosition(id);
      }));
      await new _promise2.default(res => setTimeout(res, 1000));
      await _promise2.default.all(positionIds.map(async id => {
        try {
          await rpcConnection.getPosition(id);
          _sinon2.default.assert.fail();
        } catch (err) {//eslint-ignore-line
        }
      }));
      positions = await checkPositions(streamingConnection, rpcConnection);
      _sinon2.default.assert.match(positions.local, startPositions);
      _sinon2.default.assert.match(positions.real, startPositions);
      await account.undeploy();
    }
  });
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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