'use strict';

var _should = require('should');

var _should2 = _interopRequireDefault(_should);

var _latencyMonitor = require('./latencyMonitor');

var _latencyMonitor2 = _interopRequireDefault(_latencyMonitor);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * @test {LatencyMonitor}
 */
describe('LatencyMonitor', () => {

  let monitor;

  beforeEach(() => {
    monitor = new _latencyMonitor2.default();
  });

  /**
   * @test {LatencyMonitor#onTrade}
   */
  describe('onTrade', () => {

    /**
     * @test {LatencyMonitor#onTrade}
     * @test {LatencyMonitor#tradeLatencies}
     */
    it('should process trade latencies', async () => {
      monitor.onTrade('accountId', {
        clientProcessingStarted: new Date('2020-12-07T13:22:48.000Z'),
        serverProcessingStarted: new Date('2020-12-07T13:22:49.000Z'),
        tradeStarted: new Date('2020-12-07T13:22:51.000Z'),
        tradeExecuted: new Date('2020-12-07T13:22:54.000Z')
      });
      monitor.tradeLatencies.should.match({
        clientLatency: {
          '1h': {
            p50: 1000,
            p75: 1000,
            p90: 1000,
            p95: 1000,
            p98: 1000,
            avg: 1000,
            count: 1,
            min: 1000,
            max: 1000
          },
          '1d': {
            p50: 1000,
            p75: 1000,
            p90: 1000,
            p95: 1000,
            p98: 1000,
            avg: 1000,
            count: 1,
            min: 1000,
            max: 1000
          },
          '1w': {
            p50: 1000,
            p75: 1000,
            p90: 1000,
            p95: 1000,
            p98: 1000,
            avg: 1000,
            count: 1,
            min: 1000,
            max: 1000
          }
        },
        serverLatency: {
          '1h': {
            p50: 2000,
            p75: 2000,
            p90: 2000,
            p95: 2000,
            p98: 2000,
            avg: 2000,
            count: 1,
            min: 2000,
            max: 2000
          },
          '1d': {
            p50: 2000,
            p75: 2000,
            p90: 2000,
            p95: 2000,
            p98: 2000,
            avg: 2000,
            count: 1,
            min: 2000,
            max: 2000
          },
          '1w': {
            p50: 2000,
            p75: 2000,
            p90: 2000,
            p95: 2000,
            p98: 2000,
            avg: 2000,
            count: 1,
            min: 2000,
            max: 2000
          }
        },
        brokerLatency: {
          '1h': {
            p50: 3000,
            p75: 3000,
            p90: 3000,
            p95: 3000,
            p98: 3000,
            avg: 3000,
            count: 1,
            min: 3000,
            max: 3000
          },
          '1d': {
            p50: 3000,
            p75: 3000,
            p90: 3000,
            p95: 3000,
            p98: 3000,
            avg: 3000,
            count: 1,
            min: 3000,
            max: 3000
          },
          '1w': {
            p50: 3000,
            p75: 3000,
            p90: 3000,
            p95: 3000,
            p98: 3000,
            avg: 3000,
            count: 1,
            min: 3000,
            max: 3000
          }
        }
      });
    });
  });

  /**
   * @test {LatencyMonitor#onUpdate}
   */
  describe('onUpdate', () => {

    /**
     * @test {LatencyMonitor#onUpdate}
     * @test {LatencyMonitor#updateLatencies}
     */
    it('should process update latencies', async () => {
      monitor.onUpdate('accountId', {
        eventGenerated: new Date('2020-12-07T13:22:48.000Z'),
        serverProcessingStarted: new Date('2020-12-07T13:22:49.000Z'),
        serverProcessingFinished: new Date('2020-12-07T13:22:51.000Z'),
        clientProcessingFinished: new Date('2020-12-07T13:22:54.000Z')
      });
      monitor.updateLatencies.should.match({
        brokerLatency: {
          '1h': {
            p50: 1000,
            p75: 1000,
            p90: 1000,
            p95: 1000,
            p98: 1000,
            avg: 1000,
            count: 1,
            min: 1000,
            max: 1000
          },
          '1d': {
            p50: 1000,
            p75: 1000,
            p90: 1000,
            p95: 1000,
            p98: 1000,
            avg: 1000,
            count: 1,
            min: 1000,
            max: 1000
          },
          '1w': {
            p50: 1000,
            p75: 1000,
            p90: 1000,
            p95: 1000,
            p98: 1000,
            avg: 1000,
            count: 1,
            min: 1000,
            max: 1000
          }
        },
        serverLatency: {
          '1h': {
            p50: 2000,
            p75: 2000,
            p90: 2000,
            p95: 2000,
            p98: 2000,
            avg: 2000,
            count: 1,
            min: 2000,
            max: 2000
          },
          '1d': {
            p50: 2000,
            p75: 2000,
            p90: 2000,
            p95: 2000,
            p98: 2000,
            avg: 2000,
            count: 1,
            min: 2000,
            max: 2000
          },
          '1w': {
            p50: 2000,
            p75: 2000,
            p90: 2000,
            p95: 2000,
            p98: 2000,
            avg: 2000,
            count: 1,
            min: 2000,
            max: 2000
          }
        },
        clientLatency: {
          '1h': {
            p50: 3000,
            p75: 3000,
            p90: 3000,
            p95: 3000,
            p98: 3000,
            avg: 3000,
            count: 1,
            min: 3000,
            max: 3000
          },
          '1d': {
            p50: 3000,
            p75: 3000,
            p90: 3000,
            p95: 3000,
            p98: 3000,
            avg: 3000,
            count: 1,
            min: 3000,
            max: 3000
          },
          '1w': {
            p50: 3000,
            p75: 3000,
            p90: 3000,
            p95: 3000,
            p98: 3000,
            avg: 3000,
            count: 1,
            min: 3000,
            max: 3000
          }
        }
      });
    });
  });

  /**
   * @test {LatencyMonitor#onSymbolPrice}
   */
  describe('onSymbolPrice', () => {

    /**
     * @test {LatencyMonitor#onSymbolPrice}
     * @test {LatencyMonitor#priceLatencies}
     */
    it('should process price streaming latencies', async () => {
      monitor.onSymbolPrice('accountId', 'EURUSD', {
        eventGenerated: new Date('2020-12-07T13:22:48.000Z'),
        serverProcessingStarted: new Date('2020-12-07T13:22:49.000Z'),
        serverProcessingFinished: new Date('2020-12-07T13:22:51.000Z'),
        clientProcessingFinished: new Date('2020-12-07T13:22:54.000Z')
      });
      monitor.priceLatencies.should.match({
        brokerLatency: {
          '1h': {
            p50: 1000,
            p75: 1000,
            p90: 1000,
            p95: 1000,
            p98: 1000,
            avg: 1000,
            count: 1,
            min: 1000,
            max: 1000
          },
          '1d': {
            p50: 1000,
            p75: 1000,
            p90: 1000,
            p95: 1000,
            p98: 1000,
            avg: 1000,
            count: 1,
            min: 1000,
            max: 1000
          },
          '1w': {
            p50: 1000,
            p75: 1000,
            p90: 1000,
            p95: 1000,
            p98: 1000,
            avg: 1000,
            count: 1,
            min: 1000,
            max: 1000
          }
        },
        serverLatency: {
          '1h': {
            p50: 2000,
            p75: 2000,
            p90: 2000,
            p95: 2000,
            p98: 2000,
            avg: 2000,
            count: 1,
            min: 2000,
            max: 2000
          },
          '1d': {
            p50: 2000,
            p75: 2000,
            p90: 2000,
            p95: 2000,
            p98: 2000,
            avg: 2000,
            count: 1,
            min: 2000,
            max: 2000
          },
          '1w': {
            p50: 2000,
            p75: 2000,
            p90: 2000,
            p95: 2000,
            p98: 2000,
            avg: 2000,
            count: 1,
            min: 2000,
            max: 2000
          }
        },
        clientLatency: {
          '1h': {
            p50: 3000,
            p75: 3000,
            p90: 3000,
            p95: 3000,
            p98: 3000,
            avg: 3000,
            count: 1,
            min: 3000,
            max: 3000
          },
          '1d': {
            p50: 3000,
            p75: 3000,
            p90: 3000,
            p95: 3000,
            p98: 3000,
            avg: 3000,
            count: 1,
            min: 3000,
            max: 3000
          },
          '1w': {
            p50: 3000,
            p75: 3000,
            p90: 3000,
            p95: 3000,
            p98: 3000,
            avg: 3000,
            count: 1,
            min: 3000,
            max: 3000
          }
        }
      });
    });
  });

  /**
   * @test {LatencyMonitor#onResponse}
   */
  describe('onResponse', () => {

    /**
     * @test {LatencyMonitor#onResponse}
     * @test {LatencyMonitor#requestLatencies}
     */
    it('should process request latencies', async () => {
      monitor.onResponse('accountId', 'getSymbolPrice', {
        clientProcessingStarted: new Date('2020-12-07T13:22:48.500Z'),
        serverProcessingStarted: new Date('2020-12-07T13:22:49.000Z'),
        serverProcessingFinished: new Date('2020-12-07T13:22:51.000Z'),
        clientProcessingFinished: new Date('2020-12-07T13:22:51.500Z')
      });
      monitor.requestLatencies.should.match({
        getSymbolPrice: {
          clientLatency: {
            '1h': {
              p50: 1000,
              p75: 1000,
              p90: 1000,
              p95: 1000,
              p98: 1000,
              avg: 1000,
              count: 1,
              min: 1000,
              max: 1000
            },
            '1d': {
              p50: 1000,
              p75: 1000,
              p90: 1000,
              p95: 1000,
              p98: 1000,
              avg: 1000,
              count: 1,
              min: 1000,
              max: 1000
            },
            '1w': {
              p50: 1000,
              p75: 1000,
              p90: 1000,
              p95: 1000,
              p98: 1000,
              avg: 1000,
              count: 1,
              min: 1000,
              max: 1000
            }
          },
          serverLatency: {
            '1h': {
              p50: 2000,
              p75: 2000,
              p90: 2000,
              p95: 2000,
              p98: 2000,
              avg: 2000,
              count: 1,
              min: 2000,
              max: 2000
            },
            '1d': {
              p50: 2000,
              p75: 2000,
              p90: 2000,
              p95: 2000,
              p98: 2000,
              avg: 2000,
              count: 1,
              min: 2000,
              max: 2000
            },
            '1w': {
              p50: 2000,
              p75: 2000,
              p90: 2000,
              p95: 2000,
              p98: 2000,
              avg: 2000,
              count: 1,
              min: 2000,
              max: 2000
            }
          }
        }
      });
    });
  });
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL2xpYi9tZXRhQXBpL2xhdGVuY3lNb25pdG9yLnNwZWMuZXM2Il0sIm5hbWVzIjpbImRlc2NyaWJlIiwibW9uaXRvciIsImJlZm9yZUVhY2giLCJMYXRlbmN5TW9uaXRvciIsIml0Iiwib25UcmFkZSIsImNsaWVudFByb2Nlc3NpbmdTdGFydGVkIiwiRGF0ZSIsInNlcnZlclByb2Nlc3NpbmdTdGFydGVkIiwidHJhZGVTdGFydGVkIiwidHJhZGVFeGVjdXRlZCIsInRyYWRlTGF0ZW5jaWVzIiwic2hvdWxkIiwibWF0Y2giLCJjbGllbnRMYXRlbmN5IiwicDUwIiwicDc1IiwicDkwIiwicDk1IiwicDk4IiwiYXZnIiwiY291bnQiLCJtaW4iLCJtYXgiLCJzZXJ2ZXJMYXRlbmN5IiwiYnJva2VyTGF0ZW5jeSIsIm9uVXBkYXRlIiwiZXZlbnRHZW5lcmF0ZWQiLCJzZXJ2ZXJQcm9jZXNzaW5nRmluaXNoZWQiLCJjbGllbnRQcm9jZXNzaW5nRmluaXNoZWQiLCJ1cGRhdGVMYXRlbmNpZXMiLCJvblN5bWJvbFByaWNlIiwicHJpY2VMYXRlbmNpZXMiLCJvblJlc3BvbnNlIiwicmVxdWVzdExhdGVuY2llcyIsImdldFN5bWJvbFByaWNlIl0sIm1hcHBpbmdzIjoiQUFBQTs7QUFFQTs7OztBQUNBOzs7Ozs7QUFFQTs7O0FBR0FBLFNBQVMsZ0JBQVQsRUFBMkIsTUFBTTs7QUFFL0IsTUFBSUMsT0FBSjs7QUFFQUMsYUFBVyxNQUFNO0FBQ2ZELGNBQVUsSUFBSUUsd0JBQUosRUFBVjtBQUNELEdBRkQ7O0FBSUE7OztBQUdBSCxXQUFTLFNBQVQsRUFBb0IsTUFBTTs7QUFFeEI7Ozs7QUFJQUksT0FBRyxnQ0FBSCxFQUFxQyxZQUFZO0FBQy9DSCxjQUFRSSxPQUFSLENBQWdCLFdBQWhCLEVBQTZCO0FBQzNCQyxpQ0FBeUIsSUFBSUMsSUFBSixDQUFTLDBCQUFULENBREU7QUFFM0JDLGlDQUF5QixJQUFJRCxJQUFKLENBQVMsMEJBQVQsQ0FGRTtBQUczQkUsc0JBQWMsSUFBSUYsSUFBSixDQUFTLDBCQUFULENBSGE7QUFJM0JHLHVCQUFlLElBQUlILElBQUosQ0FBUywwQkFBVDtBQUpZLE9BQTdCO0FBTUFOLGNBQVFVLGNBQVIsQ0FBdUJDLE1BQXZCLENBQThCQyxLQUE5QixDQUFvQztBQUNsQ0MsdUJBQWU7QUFDYixnQkFBTTtBQUNKQyxpQkFBSyxJQUREO0FBRUpDLGlCQUFLLElBRkQ7QUFHSkMsaUJBQUssSUFIRDtBQUlKQyxpQkFBSyxJQUpEO0FBS0pDLGlCQUFLLElBTEQ7QUFNSkMsaUJBQUssSUFORDtBQU9KQyxtQkFBTyxDQVBIO0FBUUpDLGlCQUFLLElBUkQ7QUFTSkMsaUJBQUs7QUFURCxXQURPO0FBWWIsZ0JBQU07QUFDSlIsaUJBQUssSUFERDtBQUVKQyxpQkFBSyxJQUZEO0FBR0pDLGlCQUFLLElBSEQ7QUFJSkMsaUJBQUssSUFKRDtBQUtKQyxpQkFBSyxJQUxEO0FBTUpDLGlCQUFLLElBTkQ7QUFPSkMsbUJBQU8sQ0FQSDtBQVFKQyxpQkFBSyxJQVJEO0FBU0pDLGlCQUFLO0FBVEQsV0FaTztBQXVCYixnQkFBTTtBQUNKUixpQkFBSyxJQUREO0FBRUpDLGlCQUFLLElBRkQ7QUFHSkMsaUJBQUssSUFIRDtBQUlKQyxpQkFBSyxJQUpEO0FBS0pDLGlCQUFLLElBTEQ7QUFNSkMsaUJBQUssSUFORDtBQU9KQyxtQkFBTyxDQVBIO0FBUUpDLGlCQUFLLElBUkQ7QUFTSkMsaUJBQUs7QUFURDtBQXZCTyxTQURtQjtBQW9DbENDLHVCQUFlO0FBQ2IsZ0JBQU07QUFDSlQsaUJBQUssSUFERDtBQUVKQyxpQkFBSyxJQUZEO0FBR0pDLGlCQUFLLElBSEQ7QUFJSkMsaUJBQUssSUFKRDtBQUtKQyxpQkFBSyxJQUxEO0FBTUpDLGlCQUFLLElBTkQ7QUFPSkMsbUJBQU8sQ0FQSDtBQVFKQyxpQkFBSyxJQVJEO0FBU0pDLGlCQUFLO0FBVEQsV0FETztBQVliLGdCQUFNO0FBQ0pSLGlCQUFLLElBREQ7QUFFSkMsaUJBQUssSUFGRDtBQUdKQyxpQkFBSyxJQUhEO0FBSUpDLGlCQUFLLElBSkQ7QUFLSkMsaUJBQUssSUFMRDtBQU1KQyxpQkFBSyxJQU5EO0FBT0pDLG1CQUFPLENBUEg7QUFRSkMsaUJBQUssSUFSRDtBQVNKQyxpQkFBSztBQVRELFdBWk87QUF1QmIsZ0JBQU07QUFDSlIsaUJBQUssSUFERDtBQUVKQyxpQkFBSyxJQUZEO0FBR0pDLGlCQUFLLElBSEQ7QUFJSkMsaUJBQUssSUFKRDtBQUtKQyxpQkFBSyxJQUxEO0FBTUpDLGlCQUFLLElBTkQ7QUFPSkMsbUJBQU8sQ0FQSDtBQVFKQyxpQkFBSyxJQVJEO0FBU0pDLGlCQUFLO0FBVEQ7QUF2Qk8sU0FwQ21CO0FBdUVsQ0UsdUJBQWU7QUFDYixnQkFBTTtBQUNKVixpQkFBSyxJQUREO0FBRUpDLGlCQUFLLElBRkQ7QUFHSkMsaUJBQUssSUFIRDtBQUlKQyxpQkFBSyxJQUpEO0FBS0pDLGlCQUFLLElBTEQ7QUFNSkMsaUJBQUssSUFORDtBQU9KQyxtQkFBTyxDQVBIO0FBUUpDLGlCQUFLLElBUkQ7QUFTSkMsaUJBQUs7QUFURCxXQURPO0FBWWIsZ0JBQU07QUFDSlIsaUJBQUssSUFERDtBQUVKQyxpQkFBSyxJQUZEO0FBR0pDLGlCQUFLLElBSEQ7QUFJSkMsaUJBQUssSUFKRDtBQUtKQyxpQkFBSyxJQUxEO0FBTUpDLGlCQUFLLElBTkQ7QUFPSkMsbUJBQU8sQ0FQSDtBQVFKQyxpQkFBSyxJQVJEO0FBU0pDLGlCQUFLO0FBVEQsV0FaTztBQXVCYixnQkFBTTtBQUNKUixpQkFBSyxJQUREO0FBRUpDLGlCQUFLLElBRkQ7QUFHSkMsaUJBQUssSUFIRDtBQUlKQyxpQkFBSyxJQUpEO0FBS0pDLGlCQUFLLElBTEQ7QUFNSkMsaUJBQUssSUFORDtBQU9KQyxtQkFBTyxDQVBIO0FBUUpDLGlCQUFLLElBUkQ7QUFTSkMsaUJBQUs7QUFURDtBQXZCTztBQXZFbUIsT0FBcEM7QUEyR0QsS0FsSEQ7QUFvSEQsR0ExSEQ7O0FBNEhBOzs7QUFHQXZCLFdBQVMsVUFBVCxFQUFxQixNQUFNOztBQUV6Qjs7OztBQUlBSSxPQUFHLGlDQUFILEVBQXNDLFlBQVk7QUFDaERILGNBQVF5QixRQUFSLENBQWlCLFdBQWpCLEVBQThCO0FBQzVCQyx3QkFBZ0IsSUFBSXBCLElBQUosQ0FBUywwQkFBVCxDQURZO0FBRTVCQyxpQ0FBeUIsSUFBSUQsSUFBSixDQUFTLDBCQUFULENBRkc7QUFHNUJxQixrQ0FBMEIsSUFBSXJCLElBQUosQ0FBUywwQkFBVCxDQUhFO0FBSTVCc0Isa0NBQTBCLElBQUl0QixJQUFKLENBQVMsMEJBQVQ7QUFKRSxPQUE5QjtBQU1BTixjQUFRNkIsZUFBUixDQUF3QmxCLE1BQXhCLENBQStCQyxLQUEvQixDQUFxQztBQUNuQ1ksdUJBQWU7QUFDYixnQkFBTTtBQUNKVixpQkFBSyxJQUREO0FBRUpDLGlCQUFLLElBRkQ7QUFHSkMsaUJBQUssSUFIRDtBQUlKQyxpQkFBSyxJQUpEO0FBS0pDLGlCQUFLLElBTEQ7QUFNSkMsaUJBQUssSUFORDtBQU9KQyxtQkFBTyxDQVBIO0FBUUpDLGlCQUFLLElBUkQ7QUFTSkMsaUJBQUs7QUFURCxXQURPO0FBWWIsZ0JBQU07QUFDSlIsaUJBQUssSUFERDtBQUVKQyxpQkFBSyxJQUZEO0FBR0pDLGlCQUFLLElBSEQ7QUFJSkMsaUJBQUssSUFKRDtBQUtKQyxpQkFBSyxJQUxEO0FBTUpDLGlCQUFLLElBTkQ7QUFPSkMsbUJBQU8sQ0FQSDtBQVFKQyxpQkFBSyxJQVJEO0FBU0pDLGlCQUFLO0FBVEQsV0FaTztBQXVCYixnQkFBTTtBQUNKUixpQkFBSyxJQUREO0FBRUpDLGlCQUFLLElBRkQ7QUFHSkMsaUJBQUssSUFIRDtBQUlKQyxpQkFBSyxJQUpEO0FBS0pDLGlCQUFLLElBTEQ7QUFNSkMsaUJBQUssSUFORDtBQU9KQyxtQkFBTyxDQVBIO0FBUUpDLGlCQUFLLElBUkQ7QUFTSkMsaUJBQUs7QUFURDtBQXZCTyxTQURvQjtBQW9DbkNDLHVCQUFlO0FBQ2IsZ0JBQU07QUFDSlQsaUJBQUssSUFERDtBQUVKQyxpQkFBSyxJQUZEO0FBR0pDLGlCQUFLLElBSEQ7QUFJSkMsaUJBQUssSUFKRDtBQUtKQyxpQkFBSyxJQUxEO0FBTUpDLGlCQUFLLElBTkQ7QUFPSkMsbUJBQU8sQ0FQSDtBQVFKQyxpQkFBSyxJQVJEO0FBU0pDLGlCQUFLO0FBVEQsV0FETztBQVliLGdCQUFNO0FBQ0pSLGlCQUFLLElBREQ7QUFFSkMsaUJBQUssSUFGRDtBQUdKQyxpQkFBSyxJQUhEO0FBSUpDLGlCQUFLLElBSkQ7QUFLSkMsaUJBQUssSUFMRDtBQU1KQyxpQkFBSyxJQU5EO0FBT0pDLG1CQUFPLENBUEg7QUFRSkMsaUJBQUssSUFSRDtBQVNKQyxpQkFBSztBQVRELFdBWk87QUF1QmIsZ0JBQU07QUFDSlIsaUJBQUssSUFERDtBQUVKQyxpQkFBSyxJQUZEO0FBR0pDLGlCQUFLLElBSEQ7QUFJSkMsaUJBQUssSUFKRDtBQUtKQyxpQkFBSyxJQUxEO0FBTUpDLGlCQUFLLElBTkQ7QUFPSkMsbUJBQU8sQ0FQSDtBQVFKQyxpQkFBSyxJQVJEO0FBU0pDLGlCQUFLO0FBVEQ7QUF2Qk8sU0FwQ29CO0FBdUVuQ1QsdUJBQWU7QUFDYixnQkFBTTtBQUNKQyxpQkFBSyxJQUREO0FBRUpDLGlCQUFLLElBRkQ7QUFHSkMsaUJBQUssSUFIRDtBQUlKQyxpQkFBSyxJQUpEO0FBS0pDLGlCQUFLLElBTEQ7QUFNSkMsaUJBQUssSUFORDtBQU9KQyxtQkFBTyxDQVBIO0FBUUpDLGlCQUFLLElBUkQ7QUFTSkMsaUJBQUs7QUFURCxXQURPO0FBWWIsZ0JBQU07QUFDSlIsaUJBQUssSUFERDtBQUVKQyxpQkFBSyxJQUZEO0FBR0pDLGlCQUFLLElBSEQ7QUFJSkMsaUJBQUssSUFKRDtBQUtKQyxpQkFBSyxJQUxEO0FBTUpDLGlCQUFLLElBTkQ7QUFPSkMsbUJBQU8sQ0FQSDtBQVFKQyxpQkFBSyxJQVJEO0FBU0pDLGlCQUFLO0FBVEQsV0FaTztBQXVCYixnQkFBTTtBQUNKUixpQkFBSyxJQUREO0FBRUpDLGlCQUFLLElBRkQ7QUFHSkMsaUJBQUssSUFIRDtBQUlKQyxpQkFBSyxJQUpEO0FBS0pDLGlCQUFLLElBTEQ7QUFNSkMsaUJBQUssSUFORDtBQU9KQyxtQkFBTyxDQVBIO0FBUUpDLGlCQUFLLElBUkQ7QUFTSkMsaUJBQUs7QUFURDtBQXZCTztBQXZFb0IsT0FBckM7QUEyR0QsS0FsSEQ7QUFvSEQsR0ExSEQ7O0FBNEhBOzs7QUFHQXZCLFdBQVMsZUFBVCxFQUEwQixNQUFNOztBQUU5Qjs7OztBQUlBSSxPQUFHLDBDQUFILEVBQStDLFlBQVk7QUFDekRILGNBQVE4QixhQUFSLENBQXNCLFdBQXRCLEVBQW1DLFFBQW5DLEVBQTZDO0FBQzNDSix3QkFBZ0IsSUFBSXBCLElBQUosQ0FBUywwQkFBVCxDQUQyQjtBQUUzQ0MsaUNBQXlCLElBQUlELElBQUosQ0FBUywwQkFBVCxDQUZrQjtBQUczQ3FCLGtDQUEwQixJQUFJckIsSUFBSixDQUFTLDBCQUFULENBSGlCO0FBSTNDc0Isa0NBQTBCLElBQUl0QixJQUFKLENBQVMsMEJBQVQ7QUFKaUIsT0FBN0M7QUFNQU4sY0FBUStCLGNBQVIsQ0FBdUJwQixNQUF2QixDQUE4QkMsS0FBOUIsQ0FBb0M7QUFDbENZLHVCQUFlO0FBQ2IsZ0JBQU07QUFDSlYsaUJBQUssSUFERDtBQUVKQyxpQkFBSyxJQUZEO0FBR0pDLGlCQUFLLElBSEQ7QUFJSkMsaUJBQUssSUFKRDtBQUtKQyxpQkFBSyxJQUxEO0FBTUpDLGlCQUFLLElBTkQ7QUFPSkMsbUJBQU8sQ0FQSDtBQVFKQyxpQkFBSyxJQVJEO0FBU0pDLGlCQUFLO0FBVEQsV0FETztBQVliLGdCQUFNO0FBQ0pSLGlCQUFLLElBREQ7QUFFSkMsaUJBQUssSUFGRDtBQUdKQyxpQkFBSyxJQUhEO0FBSUpDLGlCQUFLLElBSkQ7QUFLSkMsaUJBQUssSUFMRDtBQU1KQyxpQkFBSyxJQU5EO0FBT0pDLG1CQUFPLENBUEg7QUFRSkMsaUJBQUssSUFSRDtBQVNKQyxpQkFBSztBQVRELFdBWk87QUF1QmIsZ0JBQU07QUFDSlIsaUJBQUssSUFERDtBQUVKQyxpQkFBSyxJQUZEO0FBR0pDLGlCQUFLLElBSEQ7QUFJSkMsaUJBQUssSUFKRDtBQUtKQyxpQkFBSyxJQUxEO0FBTUpDLGlCQUFLLElBTkQ7QUFPSkMsbUJBQU8sQ0FQSDtBQVFKQyxpQkFBSyxJQVJEO0FBU0pDLGlCQUFLO0FBVEQ7QUF2Qk8sU0FEbUI7QUFvQ2xDQyx1QkFBZTtBQUNiLGdCQUFNO0FBQ0pULGlCQUFLLElBREQ7QUFFSkMsaUJBQUssSUFGRDtBQUdKQyxpQkFBSyxJQUhEO0FBSUpDLGlCQUFLLElBSkQ7QUFLSkMsaUJBQUssSUFMRDtBQU1KQyxpQkFBSyxJQU5EO0FBT0pDLG1CQUFPLENBUEg7QUFRSkMsaUJBQUssSUFSRDtBQVNKQyxpQkFBSztBQVRELFdBRE87QUFZYixnQkFBTTtBQUNKUixpQkFBSyxJQUREO0FBRUpDLGlCQUFLLElBRkQ7QUFHSkMsaUJBQUssSUFIRDtBQUlKQyxpQkFBSyxJQUpEO0FBS0pDLGlCQUFLLElBTEQ7QUFNSkMsaUJBQUssSUFORDtBQU9KQyxtQkFBTyxDQVBIO0FBUUpDLGlCQUFLLElBUkQ7QUFTSkMsaUJBQUs7QUFURCxXQVpPO0FBdUJiLGdCQUFNO0FBQ0pSLGlCQUFLLElBREQ7QUFFSkMsaUJBQUssSUFGRDtBQUdKQyxpQkFBSyxJQUhEO0FBSUpDLGlCQUFLLElBSkQ7QUFLSkMsaUJBQUssSUFMRDtBQU1KQyxpQkFBSyxJQU5EO0FBT0pDLG1CQUFPLENBUEg7QUFRSkMsaUJBQUssSUFSRDtBQVNKQyxpQkFBSztBQVREO0FBdkJPLFNBcENtQjtBQXVFbENULHVCQUFlO0FBQ2IsZ0JBQU07QUFDSkMsaUJBQUssSUFERDtBQUVKQyxpQkFBSyxJQUZEO0FBR0pDLGlCQUFLLElBSEQ7QUFJSkMsaUJBQUssSUFKRDtBQUtKQyxpQkFBSyxJQUxEO0FBTUpDLGlCQUFLLElBTkQ7QUFPSkMsbUJBQU8sQ0FQSDtBQVFKQyxpQkFBSyxJQVJEO0FBU0pDLGlCQUFLO0FBVEQsV0FETztBQVliLGdCQUFNO0FBQ0pSLGlCQUFLLElBREQ7QUFFSkMsaUJBQUssSUFGRDtBQUdKQyxpQkFBSyxJQUhEO0FBSUpDLGlCQUFLLElBSkQ7QUFLSkMsaUJBQUssSUFMRDtBQU1KQyxpQkFBSyxJQU5EO0FBT0pDLG1CQUFPLENBUEg7QUFRSkMsaUJBQUssSUFSRDtBQVNKQyxpQkFBSztBQVRELFdBWk87QUF1QmIsZ0JBQU07QUFDSlIsaUJBQUssSUFERDtBQUVKQyxpQkFBSyxJQUZEO0FBR0pDLGlCQUFLLElBSEQ7QUFJSkMsaUJBQUssSUFKRDtBQUtKQyxpQkFBSyxJQUxEO0FBTUpDLGlCQUFLLElBTkQ7QUFPSkMsbUJBQU8sQ0FQSDtBQVFKQyxpQkFBSyxJQVJEO0FBU0pDLGlCQUFLO0FBVEQ7QUF2Qk87QUF2RW1CLE9BQXBDO0FBMkdELEtBbEhEO0FBb0hELEdBMUhEOztBQTRIQTs7O0FBR0F2QixXQUFTLFlBQVQsRUFBdUIsTUFBTTs7QUFFM0I7Ozs7QUFJQUksT0FBRyxrQ0FBSCxFQUF1QyxZQUFZO0FBQ2pESCxjQUFRZ0MsVUFBUixDQUFtQixXQUFuQixFQUFnQyxnQkFBaEMsRUFBa0Q7QUFDaEQzQixpQ0FBeUIsSUFBSUMsSUFBSixDQUFTLDBCQUFULENBRHVCO0FBRWhEQyxpQ0FBeUIsSUFBSUQsSUFBSixDQUFTLDBCQUFULENBRnVCO0FBR2hEcUIsa0NBQTBCLElBQUlyQixJQUFKLENBQVMsMEJBQVQsQ0FIc0I7QUFJaERzQixrQ0FBMEIsSUFBSXRCLElBQUosQ0FBUywwQkFBVDtBQUpzQixPQUFsRDtBQU1BTixjQUFRaUMsZ0JBQVIsQ0FBeUJ0QixNQUF6QixDQUFnQ0MsS0FBaEMsQ0FBc0M7QUFDcENzQix3QkFBZ0I7QUFDZHJCLHlCQUFlO0FBQ2Isa0JBQU07QUFDSkMsbUJBQUssSUFERDtBQUVKQyxtQkFBSyxJQUZEO0FBR0pDLG1CQUFLLElBSEQ7QUFJSkMsbUJBQUssSUFKRDtBQUtKQyxtQkFBSyxJQUxEO0FBTUpDLG1CQUFLLElBTkQ7QUFPSkMscUJBQU8sQ0FQSDtBQVFKQyxtQkFBSyxJQVJEO0FBU0pDLG1CQUFLO0FBVEQsYUFETztBQVliLGtCQUFNO0FBQ0pSLG1CQUFLLElBREQ7QUFFSkMsbUJBQUssSUFGRDtBQUdKQyxtQkFBSyxJQUhEO0FBSUpDLG1CQUFLLElBSkQ7QUFLSkMsbUJBQUssSUFMRDtBQU1KQyxtQkFBSyxJQU5EO0FBT0pDLHFCQUFPLENBUEg7QUFRSkMsbUJBQUssSUFSRDtBQVNKQyxtQkFBSztBQVRELGFBWk87QUF1QmIsa0JBQU07QUFDSlIsbUJBQUssSUFERDtBQUVKQyxtQkFBSyxJQUZEO0FBR0pDLG1CQUFLLElBSEQ7QUFJSkMsbUJBQUssSUFKRDtBQUtKQyxtQkFBSyxJQUxEO0FBTUpDLG1CQUFLLElBTkQ7QUFPSkMscUJBQU8sQ0FQSDtBQVFKQyxtQkFBSyxJQVJEO0FBU0pDLG1CQUFLO0FBVEQ7QUF2Qk8sV0FERDtBQW9DZEMseUJBQWU7QUFDYixrQkFBTTtBQUNKVCxtQkFBSyxJQUREO0FBRUpDLG1CQUFLLElBRkQ7QUFHSkMsbUJBQUssSUFIRDtBQUlKQyxtQkFBSyxJQUpEO0FBS0pDLG1CQUFLLElBTEQ7QUFNSkMsbUJBQUssSUFORDtBQU9KQyxxQkFBTyxDQVBIO0FBUUpDLG1CQUFLLElBUkQ7QUFTSkMsbUJBQUs7QUFURCxhQURPO0FBWWIsa0JBQU07QUFDSlIsbUJBQUssSUFERDtBQUVKQyxtQkFBSyxJQUZEO0FBR0pDLG1CQUFLLElBSEQ7QUFJSkMsbUJBQUssSUFKRDtBQUtKQyxtQkFBSyxJQUxEO0FBTUpDLG1CQUFLLElBTkQ7QUFPSkMscUJBQU8sQ0FQSDtBQVFKQyxtQkFBSyxJQVJEO0FBU0pDLG1CQUFLO0FBVEQsYUFaTztBQXVCYixrQkFBTTtBQUNKUixtQkFBSyxJQUREO0FBRUpDLG1CQUFLLElBRkQ7QUFHSkMsbUJBQUssSUFIRDtBQUlKQyxtQkFBSyxJQUpEO0FBS0pDLG1CQUFLLElBTEQ7QUFNSkMsbUJBQUssSUFORDtBQU9KQyxxQkFBTyxDQVBIO0FBUUpDLG1CQUFLLElBUkQ7QUFTSkMsbUJBQUs7QUFURDtBQXZCTztBQXBDRDtBQURvQixPQUF0QztBQTBFRCxLQWpGRDtBQW1GRCxHQXpGRDtBQTJGRCxDQW5lRCIsImZpbGUiOiJsYXRlbmN5TW9uaXRvci5zcGVjLmpzIiwic291cmNlc0NvbnRlbnQiOlsiJ3VzZSBzdHJpY3QnO1xuXG5pbXBvcnQgc2hvdWxkIGZyb20gJ3Nob3VsZCc7XG5pbXBvcnQgTGF0ZW5jeU1vbml0b3IgZnJvbSAnLi9sYXRlbmN5TW9uaXRvcic7XG5cbi8qKlxuICogQHRlc3Qge0xhdGVuY3lNb25pdG9yfVxuICovXG5kZXNjcmliZSgnTGF0ZW5jeU1vbml0b3InLCAoKSA9PiB7XG5cbiAgbGV0IG1vbml0b3I7XG5cbiAgYmVmb3JlRWFjaCgoKSA9PiB7XG4gICAgbW9uaXRvciA9IG5ldyBMYXRlbmN5TW9uaXRvcigpO1xuICB9KTtcblxuICAvKipcbiAgICogQHRlc3Qge0xhdGVuY3lNb25pdG9yI29uVHJhZGV9XG4gICAqL1xuICBkZXNjcmliZSgnb25UcmFkZScsICgpID0+IHtcblxuICAgIC8qKlxuICAgICAqIEB0ZXN0IHtMYXRlbmN5TW9uaXRvciNvblRyYWRlfVxuICAgICAqIEB0ZXN0IHtMYXRlbmN5TW9uaXRvciN0cmFkZUxhdGVuY2llc31cbiAgICAgKi9cbiAgICBpdCgnc2hvdWxkIHByb2Nlc3MgdHJhZGUgbGF0ZW5jaWVzJywgYXN5bmMgKCkgPT4ge1xuICAgICAgbW9uaXRvci5vblRyYWRlKCdhY2NvdW50SWQnLCB7XG4gICAgICAgIGNsaWVudFByb2Nlc3NpbmdTdGFydGVkOiBuZXcgRGF0ZSgnMjAyMC0xMi0wN1QxMzoyMjo0OC4wMDBaJyksXG4gICAgICAgIHNlcnZlclByb2Nlc3NpbmdTdGFydGVkOiBuZXcgRGF0ZSgnMjAyMC0xMi0wN1QxMzoyMjo0OS4wMDBaJyksXG4gICAgICAgIHRyYWRlU3RhcnRlZDogbmV3IERhdGUoJzIwMjAtMTItMDdUMTM6MjI6NTEuMDAwWicpLFxuICAgICAgICB0cmFkZUV4ZWN1dGVkOiBuZXcgRGF0ZSgnMjAyMC0xMi0wN1QxMzoyMjo1NC4wMDBaJylcbiAgICAgIH0pO1xuICAgICAgbW9uaXRvci50cmFkZUxhdGVuY2llcy5zaG91bGQubWF0Y2goe1xuICAgICAgICBjbGllbnRMYXRlbmN5OiB7XG4gICAgICAgICAgJzFoJzoge1xuICAgICAgICAgICAgcDUwOiAxMDAwLFxuICAgICAgICAgICAgcDc1OiAxMDAwLFxuICAgICAgICAgICAgcDkwOiAxMDAwLFxuICAgICAgICAgICAgcDk1OiAxMDAwLFxuICAgICAgICAgICAgcDk4OiAxMDAwLFxuICAgICAgICAgICAgYXZnOiAxMDAwLFxuICAgICAgICAgICAgY291bnQ6IDEsXG4gICAgICAgICAgICBtaW46IDEwMDAsXG4gICAgICAgICAgICBtYXg6IDEwMDBcbiAgICAgICAgICB9LFxuICAgICAgICAgICcxZCc6IHtcbiAgICAgICAgICAgIHA1MDogMTAwMCxcbiAgICAgICAgICAgIHA3NTogMTAwMCxcbiAgICAgICAgICAgIHA5MDogMTAwMCxcbiAgICAgICAgICAgIHA5NTogMTAwMCxcbiAgICAgICAgICAgIHA5ODogMTAwMCxcbiAgICAgICAgICAgIGF2ZzogMTAwMCxcbiAgICAgICAgICAgIGNvdW50OiAxLFxuICAgICAgICAgICAgbWluOiAxMDAwLFxuICAgICAgICAgICAgbWF4OiAxMDAwXG4gICAgICAgICAgfSxcbiAgICAgICAgICAnMXcnOiB7XG4gICAgICAgICAgICBwNTA6IDEwMDAsXG4gICAgICAgICAgICBwNzU6IDEwMDAsXG4gICAgICAgICAgICBwOTA6IDEwMDAsXG4gICAgICAgICAgICBwOTU6IDEwMDAsXG4gICAgICAgICAgICBwOTg6IDEwMDAsXG4gICAgICAgICAgICBhdmc6IDEwMDAsXG4gICAgICAgICAgICBjb3VudDogMSxcbiAgICAgICAgICAgIG1pbjogMTAwMCxcbiAgICAgICAgICAgIG1heDogMTAwMFxuICAgICAgICAgIH1cbiAgICAgICAgfSxcbiAgICAgICAgc2VydmVyTGF0ZW5jeToge1xuICAgICAgICAgICcxaCc6IHtcbiAgICAgICAgICAgIHA1MDogMjAwMCxcbiAgICAgICAgICAgIHA3NTogMjAwMCxcbiAgICAgICAgICAgIHA5MDogMjAwMCxcbiAgICAgICAgICAgIHA5NTogMjAwMCxcbiAgICAgICAgICAgIHA5ODogMjAwMCxcbiAgICAgICAgICAgIGF2ZzogMjAwMCxcbiAgICAgICAgICAgIGNvdW50OiAxLFxuICAgICAgICAgICAgbWluOiAyMDAwLFxuICAgICAgICAgICAgbWF4OiAyMDAwXG4gICAgICAgICAgfSxcbiAgICAgICAgICAnMWQnOiB7XG4gICAgICAgICAgICBwNTA6IDIwMDAsXG4gICAgICAgICAgICBwNzU6IDIwMDAsXG4gICAgICAgICAgICBwOTA6IDIwMDAsXG4gICAgICAgICAgICBwOTU6IDIwMDAsXG4gICAgICAgICAgICBwOTg6IDIwMDAsXG4gICAgICAgICAgICBhdmc6IDIwMDAsXG4gICAgICAgICAgICBjb3VudDogMSxcbiAgICAgICAgICAgIG1pbjogMjAwMCxcbiAgICAgICAgICAgIG1heDogMjAwMFxuICAgICAgICAgIH0sXG4gICAgICAgICAgJzF3Jzoge1xuICAgICAgICAgICAgcDUwOiAyMDAwLFxuICAgICAgICAgICAgcDc1OiAyMDAwLFxuICAgICAgICAgICAgcDkwOiAyMDAwLFxuICAgICAgICAgICAgcDk1OiAyMDAwLFxuICAgICAgICAgICAgcDk4OiAyMDAwLFxuICAgICAgICAgICAgYXZnOiAyMDAwLFxuICAgICAgICAgICAgY291bnQ6IDEsXG4gICAgICAgICAgICBtaW46IDIwMDAsXG4gICAgICAgICAgICBtYXg6IDIwMDBcbiAgICAgICAgICB9XG4gICAgICAgIH0sXG4gICAgICAgIGJyb2tlckxhdGVuY3k6IHtcbiAgICAgICAgICAnMWgnOiB7XG4gICAgICAgICAgICBwNTA6IDMwMDAsXG4gICAgICAgICAgICBwNzU6IDMwMDAsXG4gICAgICAgICAgICBwOTA6IDMwMDAsXG4gICAgICAgICAgICBwOTU6IDMwMDAsXG4gICAgICAgICAgICBwOTg6IDMwMDAsXG4gICAgICAgICAgICBhdmc6IDMwMDAsXG4gICAgICAgICAgICBjb3VudDogMSxcbiAgICAgICAgICAgIG1pbjogMzAwMCxcbiAgICAgICAgICAgIG1heDogMzAwMFxuICAgICAgICAgIH0sXG4gICAgICAgICAgJzFkJzoge1xuICAgICAgICAgICAgcDUwOiAzMDAwLFxuICAgICAgICAgICAgcDc1OiAzMDAwLFxuICAgICAgICAgICAgcDkwOiAzMDAwLFxuICAgICAgICAgICAgcDk1OiAzMDAwLFxuICAgICAgICAgICAgcDk4OiAzMDAwLFxuICAgICAgICAgICAgYXZnOiAzMDAwLFxuICAgICAgICAgICAgY291bnQ6IDEsXG4gICAgICAgICAgICBtaW46IDMwMDAsXG4gICAgICAgICAgICBtYXg6IDMwMDBcbiAgICAgICAgICB9LFxuICAgICAgICAgICcxdyc6IHtcbiAgICAgICAgICAgIHA1MDogMzAwMCxcbiAgICAgICAgICAgIHA3NTogMzAwMCxcbiAgICAgICAgICAgIHA5MDogMzAwMCxcbiAgICAgICAgICAgIHA5NTogMzAwMCxcbiAgICAgICAgICAgIHA5ODogMzAwMCxcbiAgICAgICAgICAgIGF2ZzogMzAwMCxcbiAgICAgICAgICAgIGNvdW50OiAxLFxuICAgICAgICAgICAgbWluOiAzMDAwLFxuICAgICAgICAgICAgbWF4OiAzMDAwXG4gICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICB9KTtcbiAgICB9KTtcblxuICB9KTtcblxuICAvKipcbiAgICogQHRlc3Qge0xhdGVuY3lNb25pdG9yI29uVXBkYXRlfVxuICAgKi9cbiAgZGVzY3JpYmUoJ29uVXBkYXRlJywgKCkgPT4ge1xuXG4gICAgLyoqXG4gICAgICogQHRlc3Qge0xhdGVuY3lNb25pdG9yI29uVXBkYXRlfVxuICAgICAqIEB0ZXN0IHtMYXRlbmN5TW9uaXRvciN1cGRhdGVMYXRlbmNpZXN9XG4gICAgICovXG4gICAgaXQoJ3Nob3VsZCBwcm9jZXNzIHVwZGF0ZSBsYXRlbmNpZXMnLCBhc3luYyAoKSA9PiB7XG4gICAgICBtb25pdG9yLm9uVXBkYXRlKCdhY2NvdW50SWQnLCB7XG4gICAgICAgIGV2ZW50R2VuZXJhdGVkOiBuZXcgRGF0ZSgnMjAyMC0xMi0wN1QxMzoyMjo0OC4wMDBaJyksXG4gICAgICAgIHNlcnZlclByb2Nlc3NpbmdTdGFydGVkOiBuZXcgRGF0ZSgnMjAyMC0xMi0wN1QxMzoyMjo0OS4wMDBaJyksXG4gICAgICAgIHNlcnZlclByb2Nlc3NpbmdGaW5pc2hlZDogbmV3IERhdGUoJzIwMjAtMTItMDdUMTM6MjI6NTEuMDAwWicpLFxuICAgICAgICBjbGllbnRQcm9jZXNzaW5nRmluaXNoZWQ6IG5ldyBEYXRlKCcyMDIwLTEyLTA3VDEzOjIyOjU0LjAwMFonKVxuICAgICAgfSk7XG4gICAgICBtb25pdG9yLnVwZGF0ZUxhdGVuY2llcy5zaG91bGQubWF0Y2goe1xuICAgICAgICBicm9rZXJMYXRlbmN5OiB7XG4gICAgICAgICAgJzFoJzoge1xuICAgICAgICAgICAgcDUwOiAxMDAwLFxuICAgICAgICAgICAgcDc1OiAxMDAwLFxuICAgICAgICAgICAgcDkwOiAxMDAwLFxuICAgICAgICAgICAgcDk1OiAxMDAwLFxuICAgICAgICAgICAgcDk4OiAxMDAwLFxuICAgICAgICAgICAgYXZnOiAxMDAwLFxuICAgICAgICAgICAgY291bnQ6IDEsXG4gICAgICAgICAgICBtaW46IDEwMDAsXG4gICAgICAgICAgICBtYXg6IDEwMDBcbiAgICAgICAgICB9LFxuICAgICAgICAgICcxZCc6IHtcbiAgICAgICAgICAgIHA1MDogMTAwMCxcbiAgICAgICAgICAgIHA3NTogMTAwMCxcbiAgICAgICAgICAgIHA5MDogMTAwMCxcbiAgICAgICAgICAgIHA5NTogMTAwMCxcbiAgICAgICAgICAgIHA5ODogMTAwMCxcbiAgICAgICAgICAgIGF2ZzogMTAwMCxcbiAgICAgICAgICAgIGNvdW50OiAxLFxuICAgICAgICAgICAgbWluOiAxMDAwLFxuICAgICAgICAgICAgbWF4OiAxMDAwXG4gICAgICAgICAgfSxcbiAgICAgICAgICAnMXcnOiB7XG4gICAgICAgICAgICBwNTA6IDEwMDAsXG4gICAgICAgICAgICBwNzU6IDEwMDAsXG4gICAgICAgICAgICBwOTA6IDEwMDAsXG4gICAgICAgICAgICBwOTU6IDEwMDAsXG4gICAgICAgICAgICBwOTg6IDEwMDAsXG4gICAgICAgICAgICBhdmc6IDEwMDAsXG4gICAgICAgICAgICBjb3VudDogMSxcbiAgICAgICAgICAgIG1pbjogMTAwMCxcbiAgICAgICAgICAgIG1heDogMTAwMFxuICAgICAgICAgIH1cbiAgICAgICAgfSxcbiAgICAgICAgc2VydmVyTGF0ZW5jeToge1xuICAgICAgICAgICcxaCc6IHtcbiAgICAgICAgICAgIHA1MDogMjAwMCxcbiAgICAgICAgICAgIHA3NTogMjAwMCxcbiAgICAgICAgICAgIHA5MDogMjAwMCxcbiAgICAgICAgICAgIHA5NTogMjAwMCxcbiAgICAgICAgICAgIHA5ODogMjAwMCxcbiAgICAgICAgICAgIGF2ZzogMjAwMCxcbiAgICAgICAgICAgIGNvdW50OiAxLFxuICAgICAgICAgICAgbWluOiAyMDAwLFxuICAgICAgICAgICAgbWF4OiAyMDAwXG4gICAgICAgICAgfSxcbiAgICAgICAgICAnMWQnOiB7XG4gICAgICAgICAgICBwNTA6IDIwMDAsXG4gICAgICAgICAgICBwNzU6IDIwMDAsXG4gICAgICAgICAgICBwOTA6IDIwMDAsXG4gICAgICAgICAgICBwOTU6IDIwMDAsXG4gICAgICAgICAgICBwOTg6IDIwMDAsXG4gICAgICAgICAgICBhdmc6IDIwMDAsXG4gICAgICAgICAgICBjb3VudDogMSxcbiAgICAgICAgICAgIG1pbjogMjAwMCxcbiAgICAgICAgICAgIG1heDogMjAwMFxuICAgICAgICAgIH0sXG4gICAgICAgICAgJzF3Jzoge1xuICAgICAgICAgICAgcDUwOiAyMDAwLFxuICAgICAgICAgICAgcDc1OiAyMDAwLFxuICAgICAgICAgICAgcDkwOiAyMDAwLFxuICAgICAgICAgICAgcDk1OiAyMDAwLFxuICAgICAgICAgICAgcDk4OiAyMDAwLFxuICAgICAgICAgICAgYXZnOiAyMDAwLFxuICAgICAgICAgICAgY291bnQ6IDEsXG4gICAgICAgICAgICBtaW46IDIwMDAsXG4gICAgICAgICAgICBtYXg6IDIwMDBcbiAgICAgICAgICB9XG4gICAgICAgIH0sXG4gICAgICAgIGNsaWVudExhdGVuY3k6IHtcbiAgICAgICAgICAnMWgnOiB7XG4gICAgICAgICAgICBwNTA6IDMwMDAsXG4gICAgICAgICAgICBwNzU6IDMwMDAsXG4gICAgICAgICAgICBwOTA6IDMwMDAsXG4gICAgICAgICAgICBwOTU6IDMwMDAsXG4gICAgICAgICAgICBwOTg6IDMwMDAsXG4gICAgICAgICAgICBhdmc6IDMwMDAsXG4gICAgICAgICAgICBjb3VudDogMSxcbiAgICAgICAgICAgIG1pbjogMzAwMCxcbiAgICAgICAgICAgIG1heDogMzAwMFxuICAgICAgICAgIH0sXG4gICAgICAgICAgJzFkJzoge1xuICAgICAgICAgICAgcDUwOiAzMDAwLFxuICAgICAgICAgICAgcDc1OiAzMDAwLFxuICAgICAgICAgICAgcDkwOiAzMDAwLFxuICAgICAgICAgICAgcDk1OiAzMDAwLFxuICAgICAgICAgICAgcDk4OiAzMDAwLFxuICAgICAgICAgICAgYXZnOiAzMDAwLFxuICAgICAgICAgICAgY291bnQ6IDEsXG4gICAgICAgICAgICBtaW46IDMwMDAsXG4gICAgICAgICAgICBtYXg6IDMwMDBcbiAgICAgICAgICB9LFxuICAgICAgICAgICcxdyc6IHtcbiAgICAgICAgICAgIHA1MDogMzAwMCxcbiAgICAgICAgICAgIHA3NTogMzAwMCxcbiAgICAgICAgICAgIHA5MDogMzAwMCxcbiAgICAgICAgICAgIHA5NTogMzAwMCxcbiAgICAgICAgICAgIHA5ODogMzAwMCxcbiAgICAgICAgICAgIGF2ZzogMzAwMCxcbiAgICAgICAgICAgIGNvdW50OiAxLFxuICAgICAgICAgICAgbWluOiAzMDAwLFxuICAgICAgICAgICAgbWF4OiAzMDAwXG4gICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICB9KTtcbiAgICB9KTtcblxuICB9KTtcblxuICAvKipcbiAgICogQHRlc3Qge0xhdGVuY3lNb25pdG9yI29uU3ltYm9sUHJpY2V9XG4gICAqL1xuICBkZXNjcmliZSgnb25TeW1ib2xQcmljZScsICgpID0+IHtcblxuICAgIC8qKlxuICAgICAqIEB0ZXN0IHtMYXRlbmN5TW9uaXRvciNvblN5bWJvbFByaWNlfVxuICAgICAqIEB0ZXN0IHtMYXRlbmN5TW9uaXRvciNwcmljZUxhdGVuY2llc31cbiAgICAgKi9cbiAgICBpdCgnc2hvdWxkIHByb2Nlc3MgcHJpY2Ugc3RyZWFtaW5nIGxhdGVuY2llcycsIGFzeW5jICgpID0+IHtcbiAgICAgIG1vbml0b3Iub25TeW1ib2xQcmljZSgnYWNjb3VudElkJywgJ0VVUlVTRCcsIHtcbiAgICAgICAgZXZlbnRHZW5lcmF0ZWQ6IG5ldyBEYXRlKCcyMDIwLTEyLTA3VDEzOjIyOjQ4LjAwMFonKSxcbiAgICAgICAgc2VydmVyUHJvY2Vzc2luZ1N0YXJ0ZWQ6IG5ldyBEYXRlKCcyMDIwLTEyLTA3VDEzOjIyOjQ5LjAwMFonKSxcbiAgICAgICAgc2VydmVyUHJvY2Vzc2luZ0ZpbmlzaGVkOiBuZXcgRGF0ZSgnMjAyMC0xMi0wN1QxMzoyMjo1MS4wMDBaJyksXG4gICAgICAgIGNsaWVudFByb2Nlc3NpbmdGaW5pc2hlZDogbmV3IERhdGUoJzIwMjAtMTItMDdUMTM6MjI6NTQuMDAwWicpXG4gICAgICB9KTtcbiAgICAgIG1vbml0b3IucHJpY2VMYXRlbmNpZXMuc2hvdWxkLm1hdGNoKHtcbiAgICAgICAgYnJva2VyTGF0ZW5jeToge1xuICAgICAgICAgICcxaCc6IHtcbiAgICAgICAgICAgIHA1MDogMTAwMCxcbiAgICAgICAgICAgIHA3NTogMTAwMCxcbiAgICAgICAgICAgIHA5MDogMTAwMCxcbiAgICAgICAgICAgIHA5NTogMTAwMCxcbiAgICAgICAgICAgIHA5ODogMTAwMCxcbiAgICAgICAgICAgIGF2ZzogMTAwMCxcbiAgICAgICAgICAgIGNvdW50OiAxLFxuICAgICAgICAgICAgbWluOiAxMDAwLFxuICAgICAgICAgICAgbWF4OiAxMDAwXG4gICAgICAgICAgfSxcbiAgICAgICAgICAnMWQnOiB7XG4gICAgICAgICAgICBwNTA6IDEwMDAsXG4gICAgICAgICAgICBwNzU6IDEwMDAsXG4gICAgICAgICAgICBwOTA6IDEwMDAsXG4gICAgICAgICAgICBwOTU6IDEwMDAsXG4gICAgICAgICAgICBwOTg6IDEwMDAsXG4gICAgICAgICAgICBhdmc6IDEwMDAsXG4gICAgICAgICAgICBjb3VudDogMSxcbiAgICAgICAgICAgIG1pbjogMTAwMCxcbiAgICAgICAgICAgIG1heDogMTAwMFxuICAgICAgICAgIH0sXG4gICAgICAgICAgJzF3Jzoge1xuICAgICAgICAgICAgcDUwOiAxMDAwLFxuICAgICAgICAgICAgcDc1OiAxMDAwLFxuICAgICAgICAgICAgcDkwOiAxMDAwLFxuICAgICAgICAgICAgcDk1OiAxMDAwLFxuICAgICAgICAgICAgcDk4OiAxMDAwLFxuICAgICAgICAgICAgYXZnOiAxMDAwLFxuICAgICAgICAgICAgY291bnQ6IDEsXG4gICAgICAgICAgICBtaW46IDEwMDAsXG4gICAgICAgICAgICBtYXg6IDEwMDBcbiAgICAgICAgICB9XG4gICAgICAgIH0sXG4gICAgICAgIHNlcnZlckxhdGVuY3k6IHtcbiAgICAgICAgICAnMWgnOiB7XG4gICAgICAgICAgICBwNTA6IDIwMDAsXG4gICAgICAgICAgICBwNzU6IDIwMDAsXG4gICAgICAgICAgICBwOTA6IDIwMDAsXG4gICAgICAgICAgICBwOTU6IDIwMDAsXG4gICAgICAgICAgICBwOTg6IDIwMDAsXG4gICAgICAgICAgICBhdmc6IDIwMDAsXG4gICAgICAgICAgICBjb3VudDogMSxcbiAgICAgICAgICAgIG1pbjogMjAwMCxcbiAgICAgICAgICAgIG1heDogMjAwMFxuICAgICAgICAgIH0sXG4gICAgICAgICAgJzFkJzoge1xuICAgICAgICAgICAgcDUwOiAyMDAwLFxuICAgICAgICAgICAgcDc1OiAyMDAwLFxuICAgICAgICAgICAgcDkwOiAyMDAwLFxuICAgICAgICAgICAgcDk1OiAyMDAwLFxuICAgICAgICAgICAgcDk4OiAyMDAwLFxuICAgICAgICAgICAgYXZnOiAyMDAwLFxuICAgICAgICAgICAgY291bnQ6IDEsXG4gICAgICAgICAgICBtaW46IDIwMDAsXG4gICAgICAgICAgICBtYXg6IDIwMDBcbiAgICAgICAgICB9LFxuICAgICAgICAgICcxdyc6IHtcbiAgICAgICAgICAgIHA1MDogMjAwMCxcbiAgICAgICAgICAgIHA3NTogMjAwMCxcbiAgICAgICAgICAgIHA5MDogMjAwMCxcbiAgICAgICAgICAgIHA5NTogMjAwMCxcbiAgICAgICAgICAgIHA5ODogMjAwMCxcbiAgICAgICAgICAgIGF2ZzogMjAwMCxcbiAgICAgICAgICAgIGNvdW50OiAxLFxuICAgICAgICAgICAgbWluOiAyMDAwLFxuICAgICAgICAgICAgbWF4OiAyMDAwXG4gICAgICAgICAgfVxuICAgICAgICB9LFxuICAgICAgICBjbGllbnRMYXRlbmN5OiB7XG4gICAgICAgICAgJzFoJzoge1xuICAgICAgICAgICAgcDUwOiAzMDAwLFxuICAgICAgICAgICAgcDc1OiAzMDAwLFxuICAgICAgICAgICAgcDkwOiAzMDAwLFxuICAgICAgICAgICAgcDk1OiAzMDAwLFxuICAgICAgICAgICAgcDk4OiAzMDAwLFxuICAgICAgICAgICAgYXZnOiAzMDAwLFxuICAgICAgICAgICAgY291bnQ6IDEsXG4gICAgICAgICAgICBtaW46IDMwMDAsXG4gICAgICAgICAgICBtYXg6IDMwMDBcbiAgICAgICAgICB9LFxuICAgICAgICAgICcxZCc6IHtcbiAgICAgICAgICAgIHA1MDogMzAwMCxcbiAgICAgICAgICAgIHA3NTogMzAwMCxcbiAgICAgICAgICAgIHA5MDogMzAwMCxcbiAgICAgICAgICAgIHA5NTogMzAwMCxcbiAgICAgICAgICAgIHA5ODogMzAwMCxcbiAgICAgICAgICAgIGF2ZzogMzAwMCxcbiAgICAgICAgICAgIGNvdW50OiAxLFxuICAgICAgICAgICAgbWluOiAzMDAwLFxuICAgICAgICAgICAgbWF4OiAzMDAwXG4gICAgICAgICAgfSxcbiAgICAgICAgICAnMXcnOiB7XG4gICAgICAgICAgICBwNTA6IDMwMDAsXG4gICAgICAgICAgICBwNzU6IDMwMDAsXG4gICAgICAgICAgICBwOTA6IDMwMDAsXG4gICAgICAgICAgICBwOTU6IDMwMDAsXG4gICAgICAgICAgICBwOTg6IDMwMDAsXG4gICAgICAgICAgICBhdmc6IDMwMDAsXG4gICAgICAgICAgICBjb3VudDogMSxcbiAgICAgICAgICAgIG1pbjogMzAwMCxcbiAgICAgICAgICAgIG1heDogMzAwMFxuICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgfSk7XG4gICAgfSk7XG5cbiAgfSk7XG5cbiAgLyoqXG4gICAqIEB0ZXN0IHtMYXRlbmN5TW9uaXRvciNvblJlc3BvbnNlfVxuICAgKi9cbiAgZGVzY3JpYmUoJ29uUmVzcG9uc2UnLCAoKSA9PiB7XG5cbiAgICAvKipcbiAgICAgKiBAdGVzdCB7TGF0ZW5jeU1vbml0b3Ijb25SZXNwb25zZX1cbiAgICAgKiBAdGVzdCB7TGF0ZW5jeU1vbml0b3IjcmVxdWVzdExhdGVuY2llc31cbiAgICAgKi9cbiAgICBpdCgnc2hvdWxkIHByb2Nlc3MgcmVxdWVzdCBsYXRlbmNpZXMnLCBhc3luYyAoKSA9PiB7XG4gICAgICBtb25pdG9yLm9uUmVzcG9uc2UoJ2FjY291bnRJZCcsICdnZXRTeW1ib2xQcmljZScsIHtcbiAgICAgICAgY2xpZW50UHJvY2Vzc2luZ1N0YXJ0ZWQ6IG5ldyBEYXRlKCcyMDIwLTEyLTA3VDEzOjIyOjQ4LjUwMFonKSxcbiAgICAgICAgc2VydmVyUHJvY2Vzc2luZ1N0YXJ0ZWQ6IG5ldyBEYXRlKCcyMDIwLTEyLTA3VDEzOjIyOjQ5LjAwMFonKSxcbiAgICAgICAgc2VydmVyUHJvY2Vzc2luZ0ZpbmlzaGVkOiBuZXcgRGF0ZSgnMjAyMC0xMi0wN1QxMzoyMjo1MS4wMDBaJyksXG4gICAgICAgIGNsaWVudFByb2Nlc3NpbmdGaW5pc2hlZDogbmV3IERhdGUoJzIwMjAtMTItMDdUMTM6MjI6NTEuNTAwWicpXG4gICAgICB9KTtcbiAgICAgIG1vbml0b3IucmVxdWVzdExhdGVuY2llcy5zaG91bGQubWF0Y2goe1xuICAgICAgICBnZXRTeW1ib2xQcmljZToge1xuICAgICAgICAgIGNsaWVudExhdGVuY3k6IHtcbiAgICAgICAgICAgICcxaCc6IHtcbiAgICAgICAgICAgICAgcDUwOiAxMDAwLFxuICAgICAgICAgICAgICBwNzU6IDEwMDAsXG4gICAgICAgICAgICAgIHA5MDogMTAwMCxcbiAgICAgICAgICAgICAgcDk1OiAxMDAwLFxuICAgICAgICAgICAgICBwOTg6IDEwMDAsXG4gICAgICAgICAgICAgIGF2ZzogMTAwMCxcbiAgICAgICAgICAgICAgY291bnQ6IDEsXG4gICAgICAgICAgICAgIG1pbjogMTAwMCxcbiAgICAgICAgICAgICAgbWF4OiAxMDAwXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgJzFkJzoge1xuICAgICAgICAgICAgICBwNTA6IDEwMDAsXG4gICAgICAgICAgICAgIHA3NTogMTAwMCxcbiAgICAgICAgICAgICAgcDkwOiAxMDAwLFxuICAgICAgICAgICAgICBwOTU6IDEwMDAsXG4gICAgICAgICAgICAgIHA5ODogMTAwMCxcbiAgICAgICAgICAgICAgYXZnOiAxMDAwLFxuICAgICAgICAgICAgICBjb3VudDogMSxcbiAgICAgICAgICAgICAgbWluOiAxMDAwLFxuICAgICAgICAgICAgICBtYXg6IDEwMDBcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAnMXcnOiB7XG4gICAgICAgICAgICAgIHA1MDogMTAwMCxcbiAgICAgICAgICAgICAgcDc1OiAxMDAwLFxuICAgICAgICAgICAgICBwOTA6IDEwMDAsXG4gICAgICAgICAgICAgIHA5NTogMTAwMCxcbiAgICAgICAgICAgICAgcDk4OiAxMDAwLFxuICAgICAgICAgICAgICBhdmc6IDEwMDAsXG4gICAgICAgICAgICAgIGNvdW50OiAxLFxuICAgICAgICAgICAgICBtaW46IDEwMDAsXG4gICAgICAgICAgICAgIG1heDogMTAwMFxuICAgICAgICAgICAgfVxuICAgICAgICAgIH0sXG4gICAgICAgICAgc2VydmVyTGF0ZW5jeToge1xuICAgICAgICAgICAgJzFoJzoge1xuICAgICAgICAgICAgICBwNTA6IDIwMDAsXG4gICAgICAgICAgICAgIHA3NTogMjAwMCxcbiAgICAgICAgICAgICAgcDkwOiAyMDAwLFxuICAgICAgICAgICAgICBwOTU6IDIwMDAsXG4gICAgICAgICAgICAgIHA5ODogMjAwMCxcbiAgICAgICAgICAgICAgYXZnOiAyMDAwLFxuICAgICAgICAgICAgICBjb3VudDogMSxcbiAgICAgICAgICAgICAgbWluOiAyMDAwLFxuICAgICAgICAgICAgICBtYXg6IDIwMDBcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAnMWQnOiB7XG4gICAgICAgICAgICAgIHA1MDogMjAwMCxcbiAgICAgICAgICAgICAgcDc1OiAyMDAwLFxuICAgICAgICAgICAgICBwOTA6IDIwMDAsXG4gICAgICAgICAgICAgIHA5NTogMjAwMCxcbiAgICAgICAgICAgICAgcDk4OiAyMDAwLFxuICAgICAgICAgICAgICBhdmc6IDIwMDAsXG4gICAgICAgICAgICAgIGNvdW50OiAxLFxuICAgICAgICAgICAgICBtaW46IDIwMDAsXG4gICAgICAgICAgICAgIG1heDogMjAwMFxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICcxdyc6IHtcbiAgICAgICAgICAgICAgcDUwOiAyMDAwLFxuICAgICAgICAgICAgICBwNzU6IDIwMDAsXG4gICAgICAgICAgICAgIHA5MDogMjAwMCxcbiAgICAgICAgICAgICAgcDk1OiAyMDAwLFxuICAgICAgICAgICAgICBwOTg6IDIwMDAsXG4gICAgICAgICAgICAgIGF2ZzogMjAwMCxcbiAgICAgICAgICAgICAgY291bnQ6IDEsXG4gICAgICAgICAgICAgIG1pbjogMjAwMCxcbiAgICAgICAgICAgICAgbWF4OiAyMDAwXG4gICAgICAgICAgICB9XG4gICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICB9KTtcbiAgICB9KTtcblxuICB9KTtcblxufSk7XG4iXX0=