'use strict';

var _should = require('should');

var _should2 = _interopRequireDefault(_should);

var _sinon = require('sinon');

var _sinon2 = _interopRequireDefault(_sinon);

var _metatraderDemoAccountApi = require('./metatraderDemoAccountApi');

var _metatraderDemoAccountApi2 = _interopRequireDefault(_metatraderDemoAccountApi);

var _metatraderDemoAccount = require('./metatraderDemoAccount');

var _metatraderDemoAccount2 = _interopRequireDefault(_metatraderDemoAccount);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * @test {MetatraderDemoAccountApi}
 * @test {MetatraderDemoAccount}
 */
describe('MetatraderDemoAccountApi', () => {

  let sandbox;
  let api;
  let client = {
    createMT4DemoAccount: () => {},
    createMT5DemoAccount: () => {}
  };

  before(() => {
    api = new _metatraderDemoAccountApi2.default(client);
    sandbox = _sinon2.default.createSandbox();
  });

  afterEach(() => {
    sandbox.restore();
  });

  /**
   * @test {MetatraderDemoAccountApi#createMT4DemoAccount}
   */
  it('should create MT4 demo account', async () => {
    sandbox.stub(client, 'createMT4DemoAccount').resolves({
      login: '12345',
      password: 'qwerty',
      serverName: 'HugosWay-Demo3',
      investorPassword: 'qwerty'
    });
    let newAccountData = {
      balance: 10,
      email: 'test@test.com',
      leverage: 15,
      serverName: 'server'
    };
    let account = await api.createMT4DemoAccount('profileId1', newAccountData);
    account.should.match({ login: '12345', password: 'qwerty', serverName: 'HugosWay-Demo3',
      investorPassword: 'qwerty' });
    (account instanceof _metatraderDemoAccount2.default).should.be.true();
    _sinon2.default.assert.calledWith(client.createMT4DemoAccount, 'profileId1', newAccountData);
  });

  /**
   * @test {MetatraderDemoAccountApi#createMT5DemoAccount}
   */
  it('should create MT5 demo account', async () => {
    sandbox.stub(client, 'createMT5DemoAccount').resolves({
      login: '12345',
      password: 'qwerty',
      serverName: 'HugosWay-Demo3',
      investorPassword: 'qwerty'
    });
    let newAccountData = {
      balance: 15,
      email: 'test@test.com',
      leverage: 20,
      serverName: 'server'
    };
    let account = await api.createMT5DemoAccount('profileId2', newAccountData);
    account.should.match({ login: '12345', password: 'qwerty', serverName: 'HugosWay-Demo3',
      investorPassword: 'qwerty' });
    (account instanceof _metatraderDemoAccount2.default).should.be.true();
    _sinon2.default.assert.calledWith(client.createMT5DemoAccount, 'profileId2', newAccountData);
  });
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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